<!DOCTYPE html>
<html>
<head>
    <title>Payment</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/css/bootstrap.min.css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h2>Make a Payment</h2>
        <div id="payment-message" class="alert" style="display: none;"></div>
        <form id="payment-form" class="mt-4">
            <input type="hidden" name="User_id" value="1">
            <input type="hidden" name="Subscription_id" value="1">
            <div class="form-group">
                <label>Amount</label>
                <input type="number" name="Amount" value="99.99" class="form-control" step="0.01" required>
            </div>
            <div class="form-group">
                <label>Currency</label>
                <select name="Currency" class="form-control" required>
                    <option value="USD">USD</option>
                    <option value="INR">INR</option>
                </select>
            </div>
            <div class="form-group">
                <label>Payment Gateway</label>
                <select name="Payment_gateway" class="form-control" id="gateway" required>
                    <option value="paypal">PayPal</option>
                    <option value="stripe">Stripe</option>
                    <option value="razorpay">Razorpay</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Pay Now</button>
        </form>
    </div>

    <script>
        const stripe = Stripe('{{ config('stripe.key') }}');
        const razorpayKey = '{{ config('razorpay.key') }}';
        console.log('Razorpay Key:', razorpayKey);

        $('#payment-form').submit(function (e) {
            e.preventDefault();
            const gateway = $('#gateway').val();
            const data = {
                User_id: $('[name="User_id"]').val(),
                Subscription_id: $('[name="Subscription_id"]').val(),
                Amount: $('[name="Amount"]').val(),
                Currency: $('[name="Currency"]').val(),
                Payment_gateway: gateway,
            };

            if (!data.Amount || data.Amount <= 0) {
                alert('Please enter a valid amount.');
                return;
            }

            $.ajax({
                url: '/api/payments',
                method: 'POST',
                data: JSON.stringify(data),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (response) {
                    console.log('API Response:', response);
                    if (gateway === 'paypal') {
                        window.location.href = response.gateway_response.approval_url;
                    } else if (gateway === 'stripe') {
                        stripe.confirmCardPayment(response.gateway_response.client_secret, {
                            payment_method: {
                                card: { token: 'tok_visa' } // Replace with actual card element in production
                            }
                        }).then(function (result) {
                            if (result.error) {
                                alert('Stripe Error: ' + result.error.message);
                            } else if (result.paymentIntent.status === 'succeeded') {
                                $.ajax({
                                    url: '/api/payments/callback/stripe',
                                    method: 'POST',
                                    data: JSON.stringify({ Transaction_id: response.gateway_response.transaction_id }),
                                    contentType: 'application/json',
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    success: function () {
                                        alert('Payment successful!');
                                    },
                                    error: function (xhr) {
                                        alert('Callback Error: ' + xhr.responseJSON.message);
                                    }
                                });
                            }
                        });
                    } else if (gateway === 'razorpay') {
                        if (!razorpayKey || razorpayKey === '') {
                            alert('Razorpay key is missing. Check .env and config.');
                            return;
                        }
                        const options = {
                            key: razorpayKey,
                            order_id: response.gateway_response.order_id,
                            currency: data.Currency === 'INR' ? 'INR' : 'USD', // Adjust based on supported currencies
                            amount: data.Amount * 100, // Amount in paise/cents
                            name: 'Job Platform',
                            description: 'Payment for Subscription ID: ' + (data.Subscription_id || 'N/A'),
                            handler: function (response) {
                                $.ajax({
                                    url: '/api/payments/callback/razorpay',
                                    method: 'POST',
                                    data: JSON.stringify({
                                        Transaction_id: response.razorpay_order_id,
                                        razorpay_payment_id: response.razorpay_payment_id,
                                        razorpay_signature: response.razorpay_signature,
                                    }),
                                    contentType: 'application/json',
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    success: function () {
                                        alert('Payment successful!');
                                    },
                                    error: processError
                                });
                            },
                            prefill: {
                                name: 'User Name',
                                email: 'user@example.com',
                            },
                            notes: {
                                user_id: data.User_id,
                                subscription_id: data.Subscription_id,
                            },
                            theme: {
                                color: '#3399cc',
                            },
                        };
                        const rzp = new Razorpay(options);
                        try {
                            rzp.open();
                        } catch (e) {
                            alert('Razorpay Checkout Error: ' + e.message);
                            console.error('Razorpay Error:', e);
                        }
                    }
                },
                error: function (xhr) {
                    const errorMsg = xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error';
                    alert('Payment Initiation Failed: ' + errorMsg);
                    console.error('API Error:', xhr.responseJSON);
                    $('#payment-message').text('Error: ' + errorMsg).addClass('alert-danger').show();
                },
            });

            function processError(xhr) {
                const errorMsg = xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error';
                alert('Callback Error: ' + errorMsg);
                console.error('Callback Error:', xhr.responseJSON);
                $('#payment-message').text('Error: ' + errorMsg).addClass('alert-danger').show();
            }
        });
    </script>
</body>
</html>
